/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import sun.security.action.GetPropertyAction;

public final class LogFormatter
extends Formatter {
    private boolean isObsfucated = false;
    public static final String ACTION_PERFORMED = "actionPerformed";
    private final String lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
    private final SimpleDateFormat sfDateOut = new SimpleDateFormat("dd/MM/yyyy HH.mm.ss:");
    private final Date date = new Date();
    public static final String IDENT = "$Id: LogFormatter.java 836 2009-11-12 15:44:07Z paultaylor $";

    @Override
    public final String format(LogRecord record) {
        StringBuffer sb = new StringBuffer();
        this.date.setTime(record.getMillis());
        sb.append(this.sfDateOut.format(this.date));
        String recordName = record.getSourceClassName() != null ? record.getSourceClassName() + ":" + record.getSourceMethodName() : record.getLoggerName() + ":";
        if (recordName != null) {
            sb.append(recordName);
            sb.append(":");
        }
        String message = this.formatMessage(record);
        sb.append(record.getLevel().getLocalizedName());
        sb.append(": ");
        sb.append(message);
        sb.append(this.lineSeparator);
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return sb.toString();
    }
}

